/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.readers;

import com.ctc.wstx.stax.WstxInputFactory;
import eu.europa.ec.taxud.cesop.readers.XmlLocation;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidationSchema;

public final class XmlStreamReaderWrapper {
    static final XMLInputFactory inputFactory;
    private final XMLStreamReader2 streamReader;
    private final Stack<String> stack = new Stack();
    private int currentEventType = -1;
    private boolean markedAsPeek = false;

    public XmlStreamReaderWrapper(InputStream inputStream, XMLValidationSchema xsdSchema) throws XMLStreamException {
        this.streamReader = (XMLStreamReader2)inputFactory.createXMLStreamReader(inputStream, StandardCharsets.UTF_8.name());
        if (xsdSchema != null) {
            this.streamReader.validateAgainst(xsdSchema);
        }
    }

    public void markAsPeek() {
        this.markedAsPeek = true;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.markedAsPeek || this.streamReader.hasNext();
    }

    public void moveToNextElement() throws XMLStreamException {
        if (this.markedAsPeek) {
            this.markedAsPeek = false;
        } else {
            try {
                this.currentEventType = this.streamReader.next();
            }
            catch (XMLValidationException e) {
                e.getValidationProblem().setLocation(new XmlLocation(e.getValidationProblem().getLocation(), this.stack));
                throw e;
            }
            if (this.isStartElement()) {
                this.stack.push(this.streamReader.getName().getLocalPart());
            } else if (this.isEndElement()) {
                this.stack.pop();
            }
        }
    }

    public boolean isStartElement() {
        return this.currentEventType == 1;
    }

    public boolean isCharactersElement() {
        return this.currentEventType == 4 || this.currentEventType == 12;
    }

    public boolean isEndElement() {
        return this.currentEventType == 2;
    }

    public boolean goToNextStartElement() throws XMLStreamException {
        return this.goToNextStartElement(null);
    }

    public boolean goToNextStartElement(QName qName) throws XMLStreamException {
        while (this.streamReader.hasNext()) {
            this.moveToNextElement();
            if (!this.isStartElement() || qName != null && !qName.equals(this.streamReader.getName())) continue;
            return true;
        }
        return false;
    }

    public QName getStartElementName() throws XMLStreamException {
        if (this.isStartElement()) {
            return this.streamReader.getName();
        }
        throw new XMLStreamException("The current event is not a start element: " + this.currentEventType);
    }

    public QName getEndElementName() throws XMLStreamException {
        if (this.isEndElement()) {
            return this.streamReader.getName();
        }
        throw new XMLStreamException("The current event is not an end element: " + this.currentEventType);
    }

    public String getCharacters() throws XMLStreamException {
        if (this.isCharactersElement()) {
            return this.streamReader.getText();
        }
        throw new XMLStreamException("The current event is not a characters element: " + this.currentEventType);
    }

    public Map<String, String> getAttributes() throws XMLStreamException {
        if (this.isStartElement()) {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            int attributeCount = this.streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                QName attributeName = this.streamReader.getAttributeName(i);
                String attributeValue = this.streamReader.getAttributeValue(i);
                attributes.put(attributeName.getLocalPart(), attributeValue);
            }
            return attributes;
        }
        throw new XMLStreamException("The current event is not an attribute element: " + this.currentEventType);
    }

    void close() throws XMLStreamException {
        this.streamReader.close();
    }

    static {
        System.setProperty("javax.xml.accessExternalDTD", "");
        System.setProperty("org.codehaus.stax2.validation.XMLValidationSchemaFactory.w3c", "com.ctc.wstx.msv.W3CSchemaFactory");
        inputFactory = new WstxInputFactory();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }
}

